<?= $this->extend('template_front'); ?>

<?= $this->section('content'); ?>

<!-- ini buat spasi antara navbar dan greeting section -->
<div class="margin-bottom-100"></div>

<!-- Start Table-peserta -->
<section class="table-peserta margin-top-100 margin-bottom-100">

    <div class="container">



        <div class="row">
            <div class="col-md-12">

                <h2 style="text-align: center;">Data Peserta</h2>

                <hr>
            </div>

        </div>




        <div class="row">
            <div class="col">
                <div class="table-responsive">
                    <table class="table table-striped table-condensed" id="tabelCapes">
                        <thead class="thead-dark">
                            <tr>
                                <th>NO</th>
                                <th>Nama</th>
                                <th>No.Pembayaran</th>
                                <th>Kelas</th>
                                <th>Divisi</th>
                                <th>No Registrasi</th>
                                <th>Status Pembayaran</th>
                                <th>Pengumpulan Berkas</th>

                            </tr>
                        </thead>

                    </table>
                </div>
            </div>
        </div><br>
        <div class="row">
            <div class="col">
                <div class="alert alert-success" role="alert">
                    <h5 class="alert-heading">INFORMASI PEMBAYARAN FORMULIR PENDAFTARAN</h5>
                    <p>Mohon segera lakukan pembayaran ke <b>Bank Syariah Mandiri (BSM)</b> menggunakan nomor rekening sesuai dengan <b>No.Pembayaran calon peserta didik masing-masing</b> dengan nominal yang bisa dicek di <b>menu biaya</b> sesuai satuan pendidikan yang didaftar. Jangka waktu pembayaran <b>maksimal 3x24 jam</b> terhitung sejak nomor pembayaran diterbitkan. Proses update pembayaran, dilakukan pada <b>jam kerja senin - jum'at pukul 08.00-14.00 WIB</b></p>
                    <p></p>
                </div>
            </div>
        </div>
    </div>

</section>
<!-- /End Table-peserta -->

<script>
    $(document).ready(function() {

        function tabelcapes(dataks) {
            let i = "1";
            $('#tabelCapes').DataTable({
                "data": dataks,
                "responsive": true,
                "dom": "<'row'<'col-sm-12 col-md-7'l><'col-sm-12 col-md-4'f><'col-sm-12 col-md-1'B>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
                "buttons": [{
                    extend: 'pdfHtml5',
                    text: '<i class="fas fa-fw fa-file-pdf"></i>',

                    titleAttr: 'PDF'
                }],
                "columnDefs": [{
                    "className": "text-center",
                    "targets": "_all"
                }],

                "columns": [

                    {
                        "data": null,
                        "render": function() {

                            return a = i++;
                        }
                    },

                    {
                        "data": "nama_lengkap"
                    },
                    {
                        "data": "no_va",
                        "render": function(data, type, row, meta) {

                            let a = '';
                            a = `<span class="badge badge-primary">` + data + `</span>`
                            return a
                        }
                    },
                    // {
                    //     "data": "no_va"
                    // },
                    {
                        "data": "kelas"
                    },
                    {
                        "data": "divisi"
                    },
                    {
                        "data": "no_reg"
                    },
                    {

                        "data": 'status_pembayaran',

                        "render": function(data, type, row, meta) {

                            let a = '';
                            if (data == 'belum') {
                                a = `<span class="badge badge-danger">` + data + `</span>`
                            } else {
                                a = `<span class="badge badge-success">` + data + `</span>`
                            }
                            return a
                        }
                    },
                    {

                        "data": 'file',

                        "render": function(data, type, row, meta) {

                            let a = '';
                            if (data == null) {
                                a = `<span class="badge badge-danger">belum</span>`
                            } else {
                                a = `<span class="badge badge-success">sudah</span>`
                            }
                            return a
                        }
                    }

                ]
            });
        }

        //fetch Capes semua
        function fetchCapesSemua() {
            $.ajax({
                url: '<?= base_url(); ?>/fetchcapesfront',
                type: 'post',
                dataType: 'json',
                success: function(data) {
                    // console.log(data);

                    tabelcapes(data.capes)
                }
            });
        }

        fetchCapesSemua();

    });
</script>

<?= $this->endSection(); ?>