<?= $this->extend('backend/layout/template_admin'); ?>

<?= $this->section('content'); ?>

<!-- /.content-header -->

<!-- Main content -->
<section class="content">
  <div class="container-fluid">
    <!-- Small boxes (Stat box) -->
    <div class="row">
      <div class="col mb-3">
        <!-- Button trigger modal -->
        <button type="button" id="btntambahaksesutamabaru" class="btn btn-primary" data-toggle="modal" data-target="#aksesModal">
          Tambah Akses
        </button>

        <!-- Modal -->
        <div class="modal fade" id="aksesModal" tabindex="-1" aria-labelledby="aksesModalLabel" aria-hidden="true">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="aksesModalLabel">Tambah Akses</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <form method="post" action="" id="tambahaksesform">
                  <?= csrf_field(); ?>
                  <div class="form-group row">
                    <label for="link" class="col-sm-2 col-form-label">Link</label>
                    <div class="col-sm-10">
                      <input type="text" class="form-control" name="link">
                    </div>
                  </div>
                  <div class="form-group row">
                    <label for="akses" class="col-sm-2 col-form-label">Akses Role</label>
                    <div class="col-sm-10">
                      <input type="text" class="form-control" name="akses">
                    </div>
                  </div>

              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" id="btnsavemenu" class="btn btn-primary">Simpan</button>
              </div>
              </form>
            </div>
          </div>
        </div>

      </div>
    </div>


    <div class="row">
      <div class="col">
        <div class="table-responsive">
          <table class="table table-striped" id="tableAkses">
            <thead class="bg-navy">
              <tr>
                <th scope="col">No</th>
                <th scope="col">Link</th>
                <th scope="col">Akses</th>
                <th scope="col">Action</th>
              </tr>
            </thead>

          </table>
        </div>


      </div>
    </div>

    <!-- Modal Edit -->
    <div class="modal fade" id="editaksesModal" tabindex="-1" aria-labelledby="editaksesModalLabel" aria-hidden="true">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="editaksesModalLabel">Edit Akses</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <form method="post" action="" id="editaksesform">
              <?= csrf_field(); ?>
              <input type="hidden" class="form-control" name="idakses">
              <div class="form-group row">
                <label for="link" class="col-sm-2 col-form-label">Link</label>
                <div class="col-sm-10">
                  <input type="text" class="form-control" name="link">
                </div>
              </div>
              <div class="form-group row">
                <label for="akses" class="col-sm-2 col-form-label">Akses Role</label>
                <div class="col-sm-10">
                  <input type="text" class="form-control" name="akses">
                </div>
              </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            <button type="submit" id="btnupdatemenu" class="btn btn-primary">Update</button>
          </div>
          </form>
        </div>
      </div>
    </div>

  </div><!-- /.container-fluid -->
</section>
<!-- /.content -->
</div>
<!-- /.content-wrapper -->


<script>
  $(document).ready(function() {

    //fetch menu
    function fetchAkses() {
      $.ajax({
        url: '<?= base_url(); ?>/menu/fetchaksesutama',
        type: 'post',
        dataType: 'json',
        success: function(data) {
          // console.log(data);
          let i = "1";
          $('#tableAkses').DataTable({
            "data": data.aksesutama,
            "responsive": true,
            "dom": "<'row'<'col-sm-12 col-md-4'l><'col-sm-12 col-md-4'B><'col-sm-12 col-md-4'f>>" +
              "<'row'<'col-sm-12'tr>>" +
              "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
            "buttons": [
              'copy', 'excel', 'pdf'
            ],

            "columns": [{
                "data": null,
                "render": function() {
                  return a = i++;
                }
              },
              {
                "data": "link"
              },
              {
                "data": "akses"
              },
              {
                "data": null,
                "render": function(data, type, row, meta) {
                  let a = '';
                  a = `
                                    <a href="" class="badge badge-info editakses" value="${row.id}"><i class="far fa-fw fa-edit"></i></a>
                                    <a href="" value="${row.id}" class="badge badge-danger deleteakses"><i class="fas fa-fw fa-trash-alt"></i></a>`;

                  return a;
                }
              }
            ]
          });
        }
      });
    }

    fetchAkses();

    $(document).on('click', '#btntambahaksesutamabaru', function() {
      $('#tambahaksesform')[0].reset();
    })

    // save menu
    $('#tambahaksesform').submit(function() {
      event.preventDefault();

      $.ajax({
        url: '<?= base_url('/menu/saveaksesutama'); ?>',
        type: 'post',
        data: $(this).serialize(),
        dataType: 'json',
        // data: $(this).serialize(),
        beforeSend: function() {
          // setting a timeout
          $('#btnsavemenu').attr('disabled');
          $("#btnsavemenu").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);

        },
        success: function(data) {
          if (data.responce == "success") {
            $('#aksesModal').modal('hide');
            $('#tableAkses').DataTable().destroy();

            fetchAkses();
            toastr["success"](data.pesan);

          } else {
            // console.log(data);
            toastr["error"](data.pesan);
          }
        },
        complete: function() {
          $('#btnsavemenu').removeAttr('disabled');
          $("#btnsavemenu").html(`Simpan`);
        },
      });
    });

    // delete menu
    $(document).on("click", ".deleteakses", function() {
      event.preventDefault();
      let idakses = $(this).attr('value');

      Swal.fire({
        title: 'Apa kamu yakin untuk menghapusnya?',
        text: "kamu tidak akan bisa mengembalikannya",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Ya, hapus saja!'
      }).then((result) => {
        if (result.value) {
          $.ajax({
            url: '<?= base_url('/menu/deleteaksesutama'); ?>/' + idakses,
            type: 'DELETE',
            error: function() {
              alert('Something is wrong');
            },
            success: function(data) {
              $('#tableAkses').DataTable().destroy();
              fetchAkses();
              Swal.fire(
                'Deleted!',
                'File sudah terdelete.',
                'success'
              )
            }
          });

        }
      })
    });

    // modal edit
    $(document).on("click", ".editakses", function() {
      event.preventDefault();
      let idakses = $(this).attr("value")
      $.ajax({
        url: '<?= base_url('/menu/editakses'); ?>',
        type: 'post',
        data: {
          idakses: idakses
        },
        dataType: 'json',
        success: function(data) {
          if (data.responce == 'success') {
            $('#editaksesModal').modal('show');
            $("input[name='idakses']").val(data.akses.id);
            $("input[name='link']").val(data.akses.link);
            $("input[name='akses']").val(data.akses.akses);
          } else {

            toastr["error"](data.pesan);
          }

        }
      });
    });

    // edit menu

    $("#editaksesform").submit(function(event) {
      event.preventDefault();
      $.ajax({
        url: '<?= base_url(); ?>/menu/editaksesutama',
        type: 'post',
        data: $(this).serialize(),
        dataType: 'json',
        beforeSend: function() {
          // setting a timeout
          $('#btnupdatemenu').attr('disabled');
          $("#btnupdatemenu").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);

        },
        success: function(data) {
          // console.log(data);
          if (data.responce == "success") {
            $('#editaksesModal').modal('hide');
            $('#tableAkses').DataTable().destroy();
            fetchAkses();
            toastr["success"](data.pesan);
          } else {
            toastr["error"](data.pesan);
          }
        },
        complete: function() {
          $('#btnupdatemenu').removeAttr('disabled');
          $("#btnupdatemenu").html(`Update`);

        },
      });


    });

  });
</script>

<?= $this->endSection(); ?>